<?php
/**
 * ranbron enqueue scripts
 *
 * @package ranbron
 */

function ranbron_scripts() {
    wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/assets/bootstrap/css/bootstrap.min.css', array(), '0.4.7');
    wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/assets/assets/font-awesome/css/font-awesome.min.css', array(), '0.4.7');
    wp_enqueue_style( 'fn-icon', get_template_directory_uri() . '/assets/assets/fn-icon/style.css', array(), '0.4.7');
    wp_enqueue_style( 'owl-carousel', get_template_directory_uri() . '/assets/assets/owl.carousel-2/assets/owl.carousel.css', array(), '0.4.7');
    wp_enqueue_style( 'owl-theme-default', get_template_directory_uri() . '/assets/assets/owl.carousel-2/assets/owl.theme.default.min.css', array(), '0.4.7');
    wp_enqueue_style( 'magnific-popup', get_template_directory_uri() . '/assets/assets/Magnific-Popup-master/dist/magnific-popup.css', array(), '0.4.7');
    wp_enqueue_style( 'animate', get_template_directory_uri() . '/assets/assets/animate.min.css', array(), '0.4.7');
    wp_enqueue_style( 'stroke-gap-icons', get_template_directory_uri() . '/assets/assets/Stroke-Gap-Icons-Webfont/style.css', array(), '0.4.7');
    wp_enqueue_style( 'jquery.mCustomScrollbar', get_template_directory_uri() . '/assets/css/jquery.mCustomScrollbar.css', array(), '0.4.7');
    wp_enqueue_style( 'ranbron-styles', get_template_directory_uri() . '/assets/css/themestyles.css', array(), '0.4.7');
    wp_enqueue_style( 'ranbron-res', get_template_directory_uri() . '/assets/css/responsive.css', array(), '0.4.7');
	wp_enqueue_style( 'ranbron-style', get_stylesheet_uri(), '', null );

    wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/assets/assets/bootstrap/js/bootstrap.min.js', array('jquery'), null, true );
    wp_enqueue_script( 'validate', get_template_directory_uri() . '/assets/assets/jquery-validation/dist/jquery.validate.min.js', array('jquery'), null, true );
    wp_enqueue_script( 'owl-carousel', get_template_directory_uri() . '/assets/assets/owl.carousel-2/owl.carousel.min.js', array('jquery'), null, true );

	wp_enqueue_script( 'magnific-popup', get_template_directory_uri() . '/assets/assets/Magnific-Popup-master/dist/jquery.magnific-popup.min.js', array('jquery'), null, true );
	wp_enqueue_script( 'waypoints', get_template_directory_uri() . '/assets/assets/waypoints.min.js', array('jquery'), null, true );
    wp_enqueue_script( 'counterup', get_template_directory_uri() . '/assets/assets/jquery.counterup.min.js', array('jquery'), null, true );
    wp_enqueue_script( 'wow', get_template_directory_uri() . '/assets/assets/wow.min.js', array('jquery'), null, true );
	wp_enqueue_script( 'scrollTo', get_template_directory_uri() . '/assets/js/jquery.scrollTo.min.js', array('jquery'), null, true );
	wp_enqueue_script( 'jquery.mCustomScrollbar', get_template_directory_uri() . '/assets/js/jquery.mCustomScrollbar.js', array('jquery'), null, true );
    wp_enqueue_script( 'ranbron-default', get_template_directory_uri() . '/assets/js/custom.js', array('jquery'), null, true );

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }

		wp_enqueue_style( 'ranbron-fonts', ranbron_tt_g_fonts(), array(), null );

}

add_action( 'wp_enqueue_scripts', 'ranbron_scripts' );

if ( ! function_exists( 'ranbron_tt_g_fonts' ) ) {
	/**
	 * @return string Google fonts URL for the theme.
	 */
	function ranbron_tt_g_fonts() {

		$fonts_url = '';
		$fonts     = array();
		$subsets   = 'latin,latin-ext';

		/* translators: If there are characters in your language that are not supported by Merriweather, translate this to 'off'. Do not translate into your own language. */
		if ( 'off' !== _x( 'on', 'Google font: on or off', 'ranbron' ) ) {
			$fonts[] = 'Lato:300,300i,400,400i,700,700i';
			$fonts[] = 'Poppins:300,300i,400,400i,500,500i,600,600i,700,700i';
			$fonts[] = 'Playfair Display:400,700';
			$fonts[] = 'Montserrat:300,300i,400,400i,500,500i,600,600i,700,700i';
			$fonts[] = 'Open Sans:300,300i,400,400i,600,600i,700,700i';
			$fonts[] = 'Lora:400,400i,700,700i';
		}

		if ( $fonts ) {
			$fonts_url = add_query_arg( array(
				'family' => urlencode( implode( '|', $fonts ) ),
				'subset' => urlencode( $subsets ),
			), 'https://fonts.googleapis.com/css' );
		}

		return $fonts_url;
	}
}