(window.yoastPremiumWebpackJsonp=window.yoastPremiumWebpackJsonp||[]).push([[6],{13:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\nexports.ALLOW_EMPTY_TARGET = undefined;\nexports.wpseoDeleteRedirect = wpseoDeleteRedirect;\nexports.wpseoRemoveNotification = wpseoRemoveNotification;\nexports.wpseoUndoRedirect = wpseoUndoRedirect;\nexports.wpseoCreateRedirect = wpseoCreateRedirect;\n\nvar _apiFetch = __webpack_require__(14);\n\nvar _apiFetch2 = _interopRequireDefault(_apiFetch);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nvar ALLOW_EMPTY_TARGET = exports.ALLOW_EMPTY_TARGET = [410, 451];\n\n/**\n * Deletes a redirect.\n *\n * @param {string} origin The redirect\'s origin.\n * @param {string} target The redirect\'s target.\n * @param {string} type   The type of redirect.\n * @param {string} format The format of redirect.\n *\n * @returns {void}\n */\n/* global window, wpApiSettings, wpseoPremiumStrings, ajaxurl */\nfunction wpseoDeleteRedirect(origin, target, type) {\n\tvar format = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "plain";\n\n\treturn (0, _apiFetch2.default)({\n\t\tmethod: "POST",\n\t\turl: wpApiSettings.root + "yoast/v1/redirects/delete",\n\t\theaders: {\n\t\t\t"X-WP-Nonce": wpApiSettings.nonce\n\t\t},\n\t\tdata: {\n\t\t\torigin: origin,\n\t\t\ttarget: target,\n\t\t\ttype: type,\n\t\t\tformat: format\n\t\t}\n\t});\n}\n\n/**\n * Removes a notification.\n *\n * @param {object} source The DOMElement containing the alerts.\n *\n * @returns {void}\n */\nfunction wpseoRemoveNotification(source) {\n\tjQuery(source).closest(".yoast-notification").fadeOut("slow");\n}\n\n/**\n * Undoes a redirect.\n *\n * @param {string} origin The redirect\'s origin.\n * @param {string} target The redirect\'s target.\n * @param {string} type The type of redirect.\n * @param {string} nonce The nonce being used to validate the current AJAX request.\n * @param {object} source The DOMElement containing the alerts.\n *\n * @returns {void}\n */\nfunction wpseoUndoRedirect(origin, target, type, nonce, source) {\n\twpseoDeleteRedirect(origin, target, type).then(function (response) {\n\t\tif (response.success === true) {\n\t\t\twpseoRemoveNotification(source);\n\t\t}\n\t});\n}\n\n/**\n * Creates a redirect\n *\n * @param {string} origin The origin.\n * @param {string} type   The redirect type, regex or plain.\n * @param {string} nonce  The nonce.\n * @param {object} source The source of the redirect.\n *\n * @returns {void}\n */\nfunction wpseoCreateRedirect(origin, type, nonce, source) {\n\tvar target = "";\n\n\tif (parseInt(type, 10) !== 410) {\n\t\t/* eslint-disable no-alert */\n\t\ttarget = window.prompt(wpseoPremiumStrings.enter_new_url.replace("%s", origin));\n\t\t/* eslint-enable no-alert */\n\n\t\tif (target === "") {\n\t\t\t/* eslint-disable no-alert */\n\t\t\twindow.alert(wpseoPremiumStrings.error_new_url);\n\t\t\t/* eslint-enable no-alert */\n\t\t\treturn;\n\t\t}\n\t}\n\n\tjQuery.post(ajaxurl, {\n\t\taction: "wpseo_add_redirect_plain",\n\t\t/* eslint-disable-next-line camelcase */\n\t\tajax_nonce: nonce,\n\t\tredirect: {\n\t\t\torigin: origin,\n\t\t\ttarget: target,\n\t\t\ttype: type\n\t\t}\n\t}, function (response) {\n\t\tvar notice = jQuery(source).closest(".yoast-notification");\n\t\t// Remove the classes first.\n\t\tjQuery(notice).removeClass("updated").removeClass("error");\n\n\t\t// Remove possibly added redirect errors.\n\t\tjQuery(notice).find(".redirect_error").remove();\n\n\t\tif (response.error) {\n\t\t\t// Add paragraph on top of the notice with actions and set class to error.\n\t\t\tjQuery(notice).addClass("error").prepend("<p class=\\"redirect_error\\">" + response.error.message + "</p>");\n\n\t\t\treturn;\n\t\t}\n\n\t\t// Parse the success message.\n\t\tvar successMessage = "";\n\t\tif (parseInt(type, 10) === 410) {\n\t\t\tsuccessMessage = wpseoPremiumStrings.redirect_saved_no_target;\n\t\t} else {\n\t\t\tsuccessMessage = wpseoPremiumStrings.redirect_saved.replace("%2$s", "<code>" + response.target + "</code>");\n\t\t}\n\n\t\tsuccessMessage = successMessage.replace("%1$s", "<code>" + response.origin + "</code>");\n\n\t\t// Set class to updated and replace html with the success message.\n\t\tjQuery(notice).addClass("updated").html("<p>" + successMessage + "</p>");\n\t}, "json");\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///13\n')},14:function(module,exports){eval("module.exports = window.wp.apiFetch;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTQuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vZXh0ZXJuYWwgXCJ3aW5kb3cud3AuYXBpRmV0Y2hcIj9iYzBmIl0sInNvdXJjZXNDb250ZW50IjpbIm1vZHVsZS5leHBvcnRzID0gd2luZG93LndwLmFwaUZldGNoOyJdLCJtYXBwaW5ncyI6IkFBQUEiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///14\n")},91:function(module,exports,__webpack_require__){"use strict";eval("\n\nvar _functions = __webpack_require__(13);\n\nwindow.wpseoUndoRedirect = _functions.wpseoUndoRedirect; /* Internal dependencies */\n\nwindow.wpseoCreateRedirect = _functions.wpseoCreateRedirect;\nwindow.wpseoDeleteRedirect = _functions.wpseoDeleteRedirect;\nwindow.wpseoRemoveNotification = _functions.wpseoRemoveNotification;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiOTEuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vYXNzZXRzL2pzL3NyYy9yZWRpcmVjdC1ub3RpZmljYXRpb25zLmpzPzYzMWMiXSwic291cmNlc0NvbnRlbnQiOlsiLyogSW50ZXJuYWwgZGVwZW5kZW5jaWVzICovXG5pbXBvcnQge1xuXHR3cHNlb1VuZG9SZWRpcmVjdCxcblx0d3BzZW9DcmVhdGVSZWRpcmVjdCxcblx0d3BzZW9EZWxldGVSZWRpcmVjdCxcblx0d3BzZW9SZW1vdmVOb3RpZmljYXRpb24sXG59IGZyb20gXCIuL3JlZGlyZWN0cy9mdW5jdGlvbnNcIjtcblxud2luZG93Lndwc2VvVW5kb1JlZGlyZWN0ID0gd3BzZW9VbmRvUmVkaXJlY3Q7XG53aW5kb3cud3BzZW9DcmVhdGVSZWRpcmVjdCA9IHdwc2VvQ3JlYXRlUmVkaXJlY3Q7XG53aW5kb3cud3BzZW9EZWxldGVSZWRpcmVjdCA9IHdwc2VvRGVsZXRlUmVkaXJlY3Q7XG53aW5kb3cud3BzZW9SZW1vdmVOb3RpZmljYXRpb24gPSB3cHNlb1JlbW92ZU5vdGlmaWNhdGlvbjtcbiJdLCJtYXBwaW5ncyI6Ijs7QUFDQTtBQUNBO0FBTUE7QUFDQTtBQUFBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///91\n")}},[[91,0]]]);